'use strict';


var itxapp = {
	loadedScripts: {},
	config: window.toolboxConfig
};

let appRouter = null;

import('./service/AppRouter.js').then((mod) => {
	appRouter = mod['appRouter'];
	appRouter.startApp();
});


function appUrl( u ) {
	u = itxapp.config.contextPath + u;
	return u;
}


function lookupRoute( u ) {
	return appRouter.lookupRoute( u );
}

function gotoRoute( url ) {
	return appRouter.gotoRoute(url);
}


function replaceRoute( url ) {
	return appRouter.replaceRoute(url);
}



function loadWidget( widgetName, container, opts ) {
	appRouter.loadWidget( widgetName, container, opts );
}



function showErrorWidget( err ) {
	appRouter.showErrorWidget( err );
}


function loadCss( path ) {
	let url = appUrl( path );
	
	// check if sheet is already loaded
	let sheets = document.querySelectorAll('head link[rel=stylesheet]');
	for(let i=0; i < sheets.length; i++) {
		let sheetUrl = sheets[i].href.toString();
		
		if ( endsWith( sheetUrl, url ) )
			return;
	}
	
	// add
	let l = document.createElement('link');
	l.rel = 'stylesheet';
	l.href = url;
	
	document.querySelector( 'head' ).appendChild( l );
}


/**
 * handleAnchors() - handles <a>-tags
 */
function handleAnchors( e ) {
	let el = document.querySelector( e );
	
	let anchs = el.querySelectorAll( 'a' );
	
//	console.log(anchs);
	for(let i=0; i < anchs.length; i++) {
		let a = anchs.item(i);
		
		// already set?
		if (a.linkRouteSet)
			continue;
//		console.log(a);
		
		// href with ':'? => skip
		let href = a.getAttribute('href');
		
		if (!href || href.indexOf(':') != -1 || href.length == 0)
			continue;
		
		a.addEventListener('click', function(e) {
			e.preventDefault();
			
			gotoRoute( this.getAttribute('href') );
		});
//		a.setAttribute('href', '#');
		
		// mark handled
		a.linkRouteSet = true;
	}
}


// disable submit on return/enter
window.addEventListener('EzTemplate.updated', function() {
	$('form').each(function(index, node) {
		if (node.itxPreventDefaultSet)
			return;
		
		node.itxPreventDefaultSet = true;
		$(node).on('submit', function(evt) {
			evt.preventDefault();
		});
		
		$('.format-price').each(function(index, node) {
			if (node.formatPriceSet) return;
			node.formatPriceSet = true;
			
			$(node).find('input[type=text]').on('change', function() {
				this.value = format_price( this.value, true );
			});
			
		})
		
	});
});


if (!itxapp.config.desktopMode) {
	// non-desktop mode? ping every 10 minuts to refresh auth cookie
	setInterval(function() {
		postUrl( '/service/ping.do' );
	}, 60000 * 10);
}



